#define _CRT_SECURE_NO_WARNINGS

#include <cstdio>
#include <cmath>
#include <algorithm>

using namespace std;

const int maxn = 5000005;

struct Point
{
	double x, y;
	
	inline bool operator < (const Point& other) const
	{
		return this->x < other.x || (this->x == other.x && this->y < other.y);
	}
	
	inline Point operator + (const Point& other) const
	{
		Point ans;
		ans.x = this->x + other.x;
		ans.y = this->y + other.y;
		return ans;
	}
	
	inline Point operator - (const Point& other) const
	{
		Point ans;
		ans.x = this->x - other.x;
		ans.y = this->y - other.y;
		return ans;
	}
} P[maxn];

inline double cross(Point a, Point b)
{
	return (a.x*b.y) - (a.y*b.x);
}

#define sqr(x) ((x)*(x))

inline double dist(Point a, Point b)
{
	return sqrt(sqr(a.x-b.x) + sqr(a.y-b.y));
}

inline double area2(Point a, Point b, Point c)
{
	return cross(a-c, b-c);
}

int sta[maxn];
int m, n;

inline int tubao()
{
	m = 0;
	sort(P+1, P+1+n);
	for(int i = 1; i <= n; ++i)
	{
		while(m > 1 && area2(P[sta[m]], P[i], P[sta[m-1]]) >= 0)
			m--;
		sta[++m] = i;
	}
	int k = m;
	for(int i = n-1; i; --i)
	{
		while(m > k && area2(P[sta[m]], P[i], P[sta[m-1]]) >= 0)
			m--;
		sta[++m] = i;
	}
	m--;
    return m;
}

int main()
{
    freopen("hull.in", "r", stdin);
    freopen("hull.out", "w", stdout);
	scanf("%d", &n);
	for(int i = 1; i <= n; ++i)
		scanf("%lf%lf", &P[i].x, &P[i].y);
	printf("%d\n", tubao());
    fclose(stdin);
    fclose(stdout);
	return 0;
}
